import { AgentError } from "./utils.js";
import { Request, Response, RequestHandler } from "./models.js";
export { AgentError, Request, Response, RequestHandler };
export declare type JWKSOption = {
    type: "remote";
    url: string;
} | {
    type: "local";
    keySet: Record<string, unknown>;
};
export declare type ProcessRequestOptions = {
    overrideKeySet?: JWKSOption;
};
export declare function verifyRequest(signature: string, options?: ProcessRequestOptions): Promise<{
    type: string;
    timestamp: Date;
    body: Record<string, any>;
}>;
export declare function processRequest(signature: string, subhandler: RequestHandler, options?: ProcessRequestOptions): Promise<Response>;
